/* arch/arm/mach-uniphier/include/mach/debug-macro.S
 *
 *  Copyright (C) 2011 Panasonic Corporation
 *  - Derived from arch/arm/mach-realview/include/mach/debug-macro.S
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <mach/serial.h>

		.macro	addruart,rx
		mrc	p15, 0, \rx, c1, c0
		tst	\rx, #1			@ MMU enabled?
		ldreq	\rx, =UNIPHIER_UART_PHYS_ADDR	@ physical base address
		ldrne	\rx, =UNIPHIER_UART_VIRT_ADDR	@ virtual base
		.endm

		.macro	senduart, ch, rb
		strb	\ch, [\rb, #0]
		.endm

		.macro	waituart,rd,rx
		.endm

		.macro	busyuart,rd,rx
		.endm
